/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;

public class ModUtil {
    public static boolean isCorrectHarvestLevel(int strength, BlockState state) {
        Tiers tier;
        switch (strength) {
            case 1: {
                Tiers tiers = Tiers.WOOD;
                break;
            }
            case 2: {
                Tiers tiers = Tiers.STONE;
                break;
            }
            case 3: {
                Tiers tiers = Tiers.IRON;
                break;
            }
            case 4: {
                Tiers tiers = Tiers.DIAMOND;
                break;
            }
            case 5: {
                Tiers tiers = Tiers.NETHERITE;
                break;
            }
            default: {
                Tiers tiers = tier = Tiers.WOOD;
            }
        }
        if (strength > 5) {
            tier = Tiers.NETHERITE;
        }
        return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
    }

    public static double inRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static double distanceFrom(BlockPos start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.m_123341_() - end.m_123341_(), 2.0) + Math.pow(start.m_123342_() - end.m_123342_(), 2.0) + Math.pow(start.m_123343_() - end.m_123343_(), 2.0));
    }

    public static double distanceFrom(Entity start, Entity end) {
        return ModUtil.distanceFrom(start.m_20182_(), end.m_20182_());
    }

    public static double distanceFrom(Vec3 start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.f_82479_ - (double)end.m_123341_(), 2.0) + Math.pow(start.f_82480_ - (double)end.m_123342_(), 2.0) + Math.pow(start.f_82481_ - (double)end.m_123343_(), 2.0));
    }

    public static double distanceFrom(Vec3 start, Vec3 end) {
        return Math.sqrt(Math.pow(start.f_82479_ - end.f_82479_, 2.0) + Math.pow(start.f_82480_ - end.f_82480_, 2.0) + Math.pow(start.f_82481_ - end.f_82481_, 2.0));
    }

    public static List<BlockPos> getLine(int x0, int y0, int x1, int y1, float wd) {
        ArrayList<BlockPos> vects = new ArrayList<BlockPos>();
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        float ed = dx + dy == 0 ? 1.0f : Mth.m_14116_((float)((float)dx * (float)dx + (float)dy * (float)dy));
        wd = (wd + 1.0f) / 2.0f;
        while (true) {
            vects.add(new BlockPos(x0, 0, y0));
            int e2 = err;
            int x2 = x0;
            if (2 * e2 >= -dx) {
                e2 += dy;
                int y2 = y0;
                while ((float)e2 < ed * wd && (y1 != y2 || dx > dy)) {
                    vects.add(new BlockPos(x0, 0, y2 += sy));
                    e2 += dx;
                }
                if (x0 == x1) break;
                e2 = err;
                err -= dy;
                x0 += sx;
            }
            if (2 * e2 > dy) continue;
            e2 = dx - e2;
            while ((float)e2 < ed * wd && (x1 != x2 || dx < dy)) {
                vects.add(new BlockPos(x2 += sx, 0, y0));
                e2 += dy;
            }
            if (y0 == y1) break;
            err += dx;
            y0 += sy;
        }
        return vects;
    }
}

